
markup.push({


// MARK: popover template

PopoverTemplate:
{
	nsClass: "GXPopover",
	gxContentView: "PopoverContentView",
	gxValueKey: "uiState.popoverState",
},

	
PopoverContentView:
{
	nsClass: "GXDrawView",
	gxWantsLayer: true,
	gxLayout: [
		"H:|-23-[closeBtn(20)]-5-[detachBtn(20)]-5-[pinBtn(20)]",
		"V:|-24-[closeBtn(20)]",
		"V:|-24-[detachBtn(20)]",
		"V:|-24-[pinBtn(20)]"
	],
	gxChildViews:
	{
		popoverForeground: { "+": "PopoverForeShape" },
		popoverBackground: { "+": "PopoverBackShape" },
		closeBtn: { "+": "CloseButton" },
		detachBtn: { "+": "DetachButton" },
		pinBtn: { "+": "PinButton" },
	},
},

	
// -------------------------------------------------
// MARK: popover shape layers

PopoverForeShape:
{
	nsClass: "GXLayerHostingView",
	gxIsFlipped: false,
	gxLayout: [
		"H:|-0-[self]-0-|",
		"V:|-0-[self]-0-|"
	],
	gxRootLayer: {
		nsClass: "GXShapeLayer",
		gxLayerZPosition: 10,
		gxPainter: {    // for colors only
			nsClass: "GXPainter",
			gxStrokeWidth: 1.0,
			gxFrameColor: colorMono(100, 20),
//			keyWindow: {
//				gxEdgeInsets: "1, 1, 1, 1",
//				gxStrokeWidth: 2.0,
//				//gxFrameColor: colorMono(100, 20),
//				gxFrameColor: "TextSelectionColor",
//			}
		},
	},
},

	
PopoverBackShape:
{
	nsClass: "GXLayerHostingView",
	gxIsFlipped: false,
	gxLayout: [
		"H:|-0-[self]-0-|",
		"V:|-0-[self]-0-|"
	],
	gxRootLayer: {
		nsClass: "GXShapeLayer",
		gxLayerZPosition: -10,
		//gxStylesKeyPath: "payloadView.raModelObject.styles",    // CRAZY AND UGLY ++++
		gxPainter: {    // for colors only
			nsClass: "GXPainter",
			gxFillColor: "BackColor1",
			darkMode: {
				gxFrameColor: colorMono(0, 100),
				gxShadow: "{0, 0, 0, 0.4}, {0, -1}, 6",
			},
			lightMode: {
				gxFrameColor: colorMono(75, 100),
				gxShadow: "{0, 0, 0, 0.275}, {0, -1}, 5.5",
			},
//			keyWindow: {
//				//gxStrokeWidth: 3.0,
//				gxFrameColor: "SelectionColor2",
//				gxStrokeWidth: 1.5,
//			},
			gxStrokeWidth: 1.0,
		},
	},
},

	
// -------------------------------------------------
// MARK: popover buttons

RoundIconButton:
{
	nsClass: "GXButtonView",
	gxBackPainter: {
		"+": "ControlBack",
		nsClass: "GXCirclePainter",
		gxDiameter: 20,
		//gxFillColor: "BackColor3",
	},
	gxForePainter: {
		nsClass: "GXImagePainter",
		gxTintColor: "ForeColor2",
		keyWindow: {
			gxTintColor: "ForeColor1",
		},

//			on: {
//				gxTintColor: "ColorTheme1",
//			},
		gxHAlign: 0.5,
		gxVAlign: 0.5,
	}
},

	
CloseButton:
{
	"+": "RoundIconButton.popover.close",
	gxValueKey: "closeBtn",
	gxToolTip: "Close this popover",
	axTitle: "Close",
	axHelp: "Close this popover, escape key also closes",
},

DetachButton:
{
	"+": "RoundIconButton.noOn.popover.detach",
	gxValueKey: "detachBtn",
	gxToolTip: "Detach this popover from its block",
	gxOnToolTip: "Reattach this popover to its block",
	axTitle: "Detach",
	axHelp: "Detach this popover",
},
	
PinButton:
{
	"+": "RoundIconButton",
	gxValueKey: "pinBtn",
	gxHideOnNilValue: true,
	gxToolTip: "Pin this popover to make it float above all windows",
	gxOnToolTip: "Unpin this popover, to stop it from floating above all windows",
	axTitle: "Pin",
	axHelp: "Detaches and pins this popover open above all windows on the system",
	gxChildViews:
	{
		layerHost:
		{
			nsClass: "GXLayerHostingView",
			gxIsFlipped: false,	
			gxLateLayout: [
				"V:|-0-[self]-0-|",
				"H:|-0-[self]-0-|",
			],
			gxRootLayer:
			{
				nsClass: "GXCaarLayer",
				gxViewName: "pinBtnLayer",
				gxValueKey: "pinBtn",
				gxUseOnStyle: true,
				gxCaarPainter: {
					nsClass: "GXCaarPainter",
					gxAsset: "pin",
					gxAssetDuration: 0.5,
					gxEdgeInsets: "2, 2, 2, 2",
					gxTintColor: "ForeColor2",
					keyWindow: {
						gxTintColor: "ForeColor1",
					},
					on: {
						gxTintColor: "ForeColorTheme1",
					},
					gxHAlign: 0.5,
					gxVAlign: 0.5,
				},
				gxTransition: {
					nsClass: "GXUnitTransition",
					gxDuration: 0.25,
					gxReversed: true,
				},
			},
		},
	},
},

	
PopoverOnOffSwitch:
{
	nsClass: "GXSwitchView",
	gxLayerZPosition: 20,
	gxToolTip: "This block is currently on; click to switch it off, causing audio to bypass it",
	gxOffToolTip: "This block is currently off; click to switch it back on",
	gxValueKey: "node.enabled",
	axTitle: "Enable block",
	axHelp: "When Off audio bypasses this block",
	gxLayout: [
		"H:[self(52)]-11-|",
		"V:|-10-[self(23)]"
	],
	gxForePainter: "SwitchPainter.noPressed.noBlockDisabled",
},


// -------------------------------------------------
// MARK: popover editable title
	
PopoverTitle:
{
	// A textfield that looks like a title, but with an edit pencil.
	// Changes appearance to look like a textfield and has a clear button during editing.
	"+": "DarkTextField",
	gxValueKey: "nickname",
	//gxEditingKeyPath: "nicknameEditing",
	gxNilWhenEmpty: true,
	axTitle: "Block name",
	axHelp: "VO press to edit the name of this block",
	gxBaselineOffset: 8,
	gxEdgeInsets: "2, 3, 2, 2",
	gxTextPainter:
	{
		"+": "LabelFore.foreColor2.size135.noPressed",
		keyWindow: {
			gxFontColor: "ForeColor1",
		},
	},
	//gxPlaceholderPainter: "LabelFore.foreColor3.size135.noPressed",
	//gxPlaceholderKeyPath: "popoverTitle",
	gxLayout: [
		"H:|-84-[self]-70-|",
		"V:|-11-[self(22)]"
	],
	gxBackPainter:
	{
		"+": "ControlBack",
		gxCornerRadius: 999,
		gxFillColor: "",	// fill color only during editing
		editing: {
			gxFillColor: "BackColor3.noPressed",
		},
	},
	gxButtonForePainter: {
		"+": "ImagePainter.iconSize18.foreColor2.editclear",
		gxEdgeInsets: "0, 1, 5, 1",
	},
	gxPencilForePainter: "PencilForePainter",
	gxPencilBackPainter: "PencilBackPainter",
	gxIntrinsicWidth: -1,
},

PencilForePainter:
{
	"+": "ImagePainter.iconSize22.foreColor3.editpencil",
	gxEdgeInsets: "1, 1, 0, 0",
	hover: {
		gxTintColor: "ForeColor1",
	},
},
	
PencilBackPainter:
{
	nsClass: "GXCirclePainter",
	gxDiameter: 18,
	gxEdgeInsets: "0, 0, 0, 0",
	hover: {
		gxFillColor: "BackColor3",
	},
},

})
